<#ibiztemplate>
TARGET=PSDATAENTITY
</#ibiztemplate>
<#if de.getStorageMode()==1>
	<#if  de.getAllPSDEDataSets()??>
		<#assign resultSet=de.getAllPSDEDataSets()>
	</#if>
	<#if  de.getAllPSDEDataQueries()??>
		<#assign dataQueries=de.getAllPSDEDataQueries()>
	</#if>
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE mapper PUBLIC "-//mybatis.org//DTD Mapper 3.0//EN" "http://mybatis.org/dtd/mybatis-3-mapper.dtd">

<mapper	namespace="${pub.getPKGCodeName()}.core.${de.getPSSystemModule().codeName?lower_case}.mapper.${de.codeName}Mapper">

    <!--该方法用于重写mybatis中selectById方法，以实现查询逻辑属性-->
	<#comment>无视图模式-查询view的数据查询</#comment>
	<#if de.isNoViewMode()==true>
		<#list dataQueries as singleQuery>
			<#if singleQuery.getCodeName()?lower_case=='view'>
				<#if singleQuery.getAllPSDEDataQueryCodes()??>
					<#assign queryCodeList = singleQuery.getAllPSDEDataQueryCodes()>
					<#list singleQuery.getAllPSDEDataQueryCodes() as dedqcode>
						<#assign dbtype=dedqcode.getDBType()?lower_case?replace("mysql5","mysql")>
	<select id="selectById"  resultMap="${de.codeName}ResultMap" databaseId="${dbtype}">
        <![CDATA[select t1.* from (${contextParamConvert(srfjavasqlcode(dedqcode.getQueryCode()))}) t1 where ${de.getKeyPSDEField().name?lower_case}=<#noparse>#{id}</#noparse>]]>
    </select>
					</#list>
				</#if>
				<#break>
			</#if>
		</#list>
	<#else>
		<#comment>直接查询视图</#comment>
		<#list dataQueries as singleQuery>
			<#list singleQuery.getAllPSDEDataQueryCodes() as dedqcode>
				<#assign dbtype=dedqcode.getDBType()?lower_case?replace("mysql5","mysql")>
	<select id="selectById"  resultMap="${de.codeName}ResultMap" databaseId="${dbtype}">
        <![CDATA[select * from ${de.getViewName()?lower_case} t1     where  ${de.getKeyPSDEField().name?lower_case}=<#noparse>#{id}</#noparse>]]>
    </select>
			</#list>
			<#break>
		</#list>
	</#if>

    <!--通过mybatis将查询结果注入到entity中,通过配置autoMapping="true"由mybatis自动处理映射关系 -->
    <resultMap id="${de.codeName}ResultMap" type="${pub.getPKGCodeName()}.core.${de.getPSSystemModule().codeName?lower_case}.domain.${de.codeName}" autoMapping="true">
        <id property="${srfcaseformat(de.getKeyPSDEField().codeName,'l_u2lC')}" column="${de.getKeyPSDEField().getName()?lower_case}" /><!--主键字段映射-->
		<#comment>外键值字段映射：由于需要将一个数据库列注入到2个domian属性中(主关系实体对象)，由于已经手动将列映射给主关系对象，所以autoMapping将不会自动注入外键id，需要再次声明映射关系</#comment>
            <#comment>属性名称与代码名称不一致时，强制进行映射</#comment>
            <#list item.getPSDEFields() as defield>
            <#if defield.isKeyDEField()!=true && ((defield.getDataType())!"")!='ONE2MANYDATA'>
                <#if srfcaseformat(defield.codeName,'l_u2lC')?lower_case != defield.name?lower_case || defield.getDataType()=='PICKUP'>
		<result property="${srfcaseformat(defield.codeName,'l_u2lC')}" column="${defield.getName()?lower_case}" />
                </#if>
            </#if>
            </#list>
            
        <#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' >
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
						<#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
						<#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
                            <#if MinorEntity.getStorageMode()==0 && MajorPSDER.getPSOne2ManyDataDEField()?? && MajorPSDER.getPSOne2ManyDataDEField().isPhisicalDEField()==true>
                            <#assign columnname=MajorPSDER.getPSOne2ManyDataDEField().getName()?lower_case>
		<result property="${srfcaseformat(listcode,'l_u2lC')}" column="${columnname}" typeHandler="${pub.getPKGCodeName()}.core.${MinorEntity.getPSSystemModule().codeName?lower_case}.domain.handlers.${MinorEntity.codeName}TypeHandler" />
                            </#if>
		<#--<collection property="${srfcaseformat(listcode,'l_u2lC')}" ofType="${pub.getPKGCodeName()}.core.${MinorEntity.getPSSystemModule().codeName?lower_case}.domain.${MinorEntity.codeName}" column="${de.getKeyPSDEField().getName()?lower_case}" select="${pub.getPKGCodeName()}.core.${MinorEntity.getPSSystemModule().codeName?lower_case}.mapper.${MinorEntity.codeName}Mapper.selectBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}" fetchType="lazy"></collection>-->
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
		
		<#comment>1：N关系中，在子实体中创建父实体的实例对象</#comment>
		<#if de.getMinorPSDERs?? && de.getMinorPSDERs()??>
			<#list de.getMinorPSDERs() as MinorPSDER>
				<#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N'>
					<#if MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()??>
						<#assign MajorEntity = MinorPSDER.getMajorPSDataEntity()>
						<#if MajorEntity.name?? && MinorPSDER.getCodeName()?? && MajorEntity.getStorageMode()==1>
							<#if MinorPSDER.getPSPickupDEField?? && MinorPSDER.getPSPickupDEField()??>
								<#assign MajorkeyField = MajorEntity.getKeyPSDEField()>
								<#assign MajorField = MinorPSDER.getPSPickupDEField()>
		<!--通过mybatis自动注入关系属性[主实体]，fetchType="lazy"为懒加载配置 -->
		<association property="${srfcaseformat(MinorPSDER.getCodeName(),'l_u2lC')}" javaType="${pub.getPKGCodeName()}.core.${MajorEntity.getPSSystemModule().codeName?lower_case}.domain.${MajorEntity.codeName}" column="${MajorField.getName()?lower_case}" select="${pub.getPKGCodeName()}.core.${MajorEntity.getPSSystemModule().codeName?lower_case}.mapper.${MajorEntity.codeName}Mapper.selectById" fetchType="lazy"></association>
							</#if>
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
    </resultMap>

    <#comment>1：N关系中，在子实体中创建父实体的实例对象</#comment>
	<#if de.getMinorPSDERs?? && de.getMinorPSDERs()??>
		<#list de.getMinorPSDERs() as MinorPSDER>
			<#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N'>
				<#if MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()??>
					<#assign MajorEntity = MinorPSDER.getMajorPSDataEntity()>
					<#if MajorEntity.name?? && MinorPSDER.getCodeName()?? >
						<#if MinorPSDER.getPSPickupDEField?? && MinorPSDER.getPSPickupDEField()??>
							<#assign MajorkeyField = MajorEntity.getKeyPSDEField()>
							<#assign MajorField = MinorPSDER.getPSPickupDEField()>
	<!--关系实体暴露select方法供主实体通过外键查询关系实体数据[实体关系名称:${MinorPSDER.getName()}] -->
							<#if de.getDefaultPSDEDataSet()??>
								<#assign deDefaultDataSet=de.getDefaultPSDEDataSet()>
								<#if deDefaultDataSet.getPSDEDataQueries()??>
									<#assign enableOrderby=false>
									<#if deDefaultDataSet.getMajorSortPSDEField()?? ||  deDefaultDataSet.getMinorSortPSDEField()??>
										<#assign enableOrderby=true>
									</#if>
									<#assign enableGroup=false>
									<#if deDefaultDataSet.isEnableGroup()>
										<#list deDefaultDataSet.getPSDEDataSetGroupParams() as groupParam>
											<#if groupParam.isEnableGroup()>
												<#assign enableGroup=true>
												<#break>
											</#if>
										</#list>
									</#if>
	 <select id="selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}" resultMap="${de.codeName}ResultMap">
	 <#if enableGroup || enableOrderby>
	select <#if enableGroup><@outputGroup deDefaultDataSet/><#else>*</#if> from (
	 </#if>
         select t1.* from (
         <#if deDefaultDataSet.getPSDEDataQueries()??>
			 <#list deDefaultDataSet.getPSDEDataQueries() as defaultDQ>
				 <#if defaultDQ_index gt 0>
                 union all
				 </#if>
                <include refid="${defaultDQ.getCodeName()}" />
			 </#list>
		 </#if>
			 ) t1
			 where  ${MajorField.getName()?lower_case}=<#noparse>#{</#noparse>${MajorkeyField.codeName?lower_case}<#noparse>}</#noparse>
	<#if enableGroup || enableOrderby>
		 )t1
		<#if enableGroup>
		 group by <#assign groupIndex = 0 ><#list deDefaultDataSet.getPSDEDataSetGroupParams() as groupParam><#if groupParam.isEnableGroup()><#if groupIndex gt 0>,</#if><#if groupParam.getGroupCode()??>${groupParam.getGroupCode()}<#else>${groupParam.getName()}</#if><#assign groupIndex = groupIndex + 1 ></#if></#list>
		</#if>
		<#if enableOrderby>
		 order by <#if deDefaultDataSet.getMajorSortPSDEField()??>${deDefaultDataSet.getMajorSortPSDEField().getName()?lower_case}</#if> <#if deDefaultDataSet.getMajorSortDir()??> ${deDefaultDataSet.getMajorSortDir()?lower_case}</#if> <#if deDefaultDataSet.getMinorSortPSDEField()??>, ${deDefaultDataSet.getMinorSortPSDEField().getName()?lower_case} </#if> <#if deDefaultDataSet.getMinorSortDir()??> ${deDefaultDataSet.getMinorSortDir()?lower_case}</#if>
		</#if>
	</#if>
     </select>
								</#if>
							</#if>
						</#if>
					</#if>
				</#if>
			</#if>
		</#list>
	</#if>

	<#comment>暂未实现多数据源，暂时先发布单数据库</#comment>
	<#if resultSet??>
		<#list resultSet as  singleSet>
			<#if singleSet.getPSDEDataQueries()??>
				<#assign enableOrderby=false>
				<#if singleSet.getMajorSortPSDEField()?? ||  singleSet.getMinorSortPSDEField()??>
					<#assign enableOrderby=true>
				</#if>
				<#assign enableGroup=false>
				<#if singleSet.isEnableGroup()>
				<#list singleSet.getPSDEDataSetGroupParams() as groupParam>
					<#if groupParam.isEnableGroup()>
					<#assign enableGroup=true>
					<#break>
					</#if>
				</#list>
				</#if>
    <!--数据集合[${singleSet.getCodeName()}]-->
	 <select id="search${singleSet.getCodeName()}"  parameterType="${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.filter.${de.codeName}SearchContext"  <#if singleSet.isEnableGroup()>resultType="java.util.HashMap"<#else>resultMap="${de.codeName}ResultMap"</#if>>
	 <#if enableGroup || enableOrderby>
	 	select <#if enableGroup><@outputGroup singleSet/><#else>*</#if> from (
	 </#if>
         select t1.* from (
            <#list singleSet.getPSDEDataQueries() as dataQuery>
				<#if dataQuery_index gt 0>
                 union all
				</#if>
                <include refid="${dataQuery.getCodeName()}" />
			</#list>
         )t1
         <where><if test="ew!=null and ew.sqlSegment!=null and !ew.emptyOfWhere"><#noparse>${ew.sqlSegment}</#noparse></if></where>
         <if test="ew!=null and ew.sqlSegment!=null and ew.emptyOfWhere"><#noparse>${ew.sqlSegment}</#noparse></if>
	<#if enableGroup || enableOrderby>
		 )t1
		<#if enableGroup>
		 group by <#assign groupIndex = 0 ><#list singleSet.getPSDEDataSetGroupParams() as groupParam><#if groupParam.isEnableGroup()><#if groupIndex gt 0>,</#if><#if groupParam.getGroupCode()??>${groupParam.getGroupCode()}<#else>${groupParam.getName()}</#if><#assign groupIndex = groupIndex + 1 ></#if></#list>
		</#if>
		<#if enableOrderby>
		 order by <#if singleSet.getMajorSortPSDEField()??>${singleSet.getMajorSortPSDEField().getName()?lower_case}</#if> <#if singleSet.getMajorSortDir()??> ${singleSet.getMajorSortDir()?lower_case}</#if> <#if singleSet.getMinorSortPSDEField()??>, ${singleSet.getMinorSortPSDEField().getName()?lower_case} </#if> <#if singleSet.getMinorSortDir()??> ${singleSet.getMinorSortDir()?lower_case}</#if>
		</#if>
	</#if>
     </select>

			</#if>
		</#list>
	</#if>
    <#comment>数据查询</#comment>
    <#if  de.getAllPSDEDataQueries()??>
		<#list de.getAllPSDEDataQueries() as singleQuery>
			<#if singleQuery.getAllPSDEDataQueryCodes()??>
				<#list singleQuery.getAllPSDEDataQueryCodes() as dedqcode>
					<#assign dbtype=dedqcode.getDBType()?lower_case?replace("mysql5","mysql")>
					<#assign hasIgnoreNullValueCond=checkIgnoreNullvalueCond(dedqcode)>
    <!--数据查询[${singleQuery.getCodeName()}]-->
    <sql id="${singleQuery.getCodeName()}" databaseId="${dbtype}">
		<#comment>判断是否存在忽略空值条件</#comment>
		<#if hasIgnoreNullValueCond>
		<![CDATA[ ${contextParamConvert(srfjavasqlcode(dedqcode.getQueryCode()))} ]]>
			<#if dedqcode.getPSDEDataQueryCodeConds()??>
				<#list dedqcode.getPSDEDataQueryCodeConds() as dedqfieldcond>
					<#if (dedqfieldcond_index==0)> WHERE </#if>	<#if (dedqfieldcond_index>0)> AND </#if>${checkNullContextParamConvert(srfjavasqlcode(dedqfieldcond.getCustomCond()))}
				</#list>
			</#if>
		<#else>
		<![CDATA[ ${contextParamConvert(srfjavasqlcode(dedqcode.getQueryCode()))}
			<#if dedqcode.getPSDEDataQueryCodeConds()??>
				<#list dedqcode.getPSDEDataQueryCodeConds() as dedqfieldcond>
					<#if (dedqfieldcond_index==0)> WHERE </#if>	<#if (dedqfieldcond_index>0)> AND </#if>${contextParamConvert(srfjavasqlcode(dedqfieldcond.getCustomCond()))}
				</#list>
			</#if>]]>
		</#if>
    </sql>
				</#list>
			</#if>
		</#list>
	</#if>
</mapper>
</#if>

<#comment>数据查询context条件转换</#comment>
<#function contextParamConvert contextParam>
	<#comment>补充上下文的IN查询(in通过$获取参数,其余为#)： IN (${srfdatacontext('cityid','{"defname":"CITYID","dename":"CITY"}')}) -->IN ( ${srf.srfdatacontext.cityid} )  </#comment>
	<#assign resultParam=contextParam?replace("(IN|in) \\(\\$\\{srf(datacontext|sessioncontext|webcontext)\\('(\\w+)','(.*?)'\\)}\\)","$1 (\\$\{srf.$2.$3})","r")>
	<#comment>平台配置格式替换${srfdatacontext('cityid','{"defname":"CITYID","dename":"CITY"}')}  --> #{srf.srfdatacontext.cityid}   </#comment>
	<#assign resultParam=resultParam?replace("\\$\\{srf(datacontext|sessioncontext|webcontext)\\('(\\w+)','(.*?)'\\)}","#\{srf.$1.$2}","r")>
	<#comment>用户配置格式替换${srfdatacontext('cityid')}  --> #{srf.srfdatacontext.cityid}   </#comment>
	<#assign resultParam=resultParam?replace("\\$\\{srf(datacontext|sessioncontext|webcontext)\\('(\\w+)'\\)}","#\{srf.$1.$2}","r")>
	<#comment>将上下文参数转小写 #{srf.srfdatacontext.SRFORGID} --> #{srf.srfdatacontext.srforgid}</#comment>
	<#assign params=resultParam?matches('srf.(datacontext|sessioncontext|webcontext).(\\w+)')>
	<#list params as param>
		<#assign resultParam=resultParam?replace(param,param?lower_case,'i')>
	</#list>
	<#return resultParam>
</#function>

<#comment>数据查询忽略空值条件转换</#comment>
<#function checkNullContextParamConvert contextParam>
	<#comment>获取数据查询中的条件，并对条件进行转义 <![CDATA[ age <='20' ]]></#comment>
	<#assign resultParam=contextParam?replace("(\\s+[\\w|\\.|\\`]+\\s*?)(<>|<=|<|>=|>)(\\s*[\\w|\\'|$\{}()'\",:\\\\]+\\s+?)"," <![CDATA[ $1$2$3 ]]> ","r")>
	<#comment>补充上下文的IN查询(in通过$获取参数,其余为#)</#comment>
	<#assign resultParam=resultParam?replace("<#assign _value=srf(datacontext|sessioncontext|webcontext)\\('(\\w+)','(.*?)'\\)><#if _value\\?length gt 0>(.*?)\\(\\$\\{_value}\\)<#else>1=1</#if>","<choose><when test=\"srf.$1.$2 != null\"> <![CDATA[ $4  \\$\{srf.$1.$2}  ]]> </when><otherwise>1=1</otherwise></choose>","r")>
	<#comment>获取模型中的空值条件，在条件外层补充mybatis判断条件 <choose><when test="srf.datacontext.name != null"> <![CDATA[ t1.`NAME` <= #{srf.datacontext.name}  ]]> </when><otherwise>1=1</otherwise></choose>  </#comment>
	<#assign resultParam=resultParam?replace("<#assign _value=srf(datacontext|sessioncontext|webcontext)\\('(\\w+)','(.*?)'\\)><#if _value\\?length gt 0>(.*?)\\$\\{_value}.*?<#else>1=1</#if>","<choose><when test=\"srf.$1.$2 != null\"> <![CDATA[ $4  #\{srf.$1.$2}  ]]> </when><otherwise>1=1</otherwise></choose>","r")>
	<#comment>对数据查询中的其余条件的context进行解析</#comment>
	<#assign resultParam=contextParamConvert(resultParam)>
	<#return resultParam>
</#function>

<#comment>计算当前数据查询中是否包含空值忽略的条件</#comment>
<#function checkIgnoreNullvalueCond dataQueryCode>
	<#if dataQueryCode.getPSDEDataQueryCodeConds()??>
		<#list dataQueryCode.getPSDEDataQueryCodeConds() as dedqfieldcond>
			<#if srfjavasqlcode(dedqfieldcond.getCustomCond())?matches("(.*?)srf(datacontext|sessioncontext|webcontext)(.*?)\\\\\"ignoreempty\\\\\":true(.*?)")>
				<#return true>
			</#if>
		</#list>
	</#if>
	<#return false>
</#function>

<#comment>输出数据集分组</#comment>
<#macro outputGroup singleSet>
	<#list singleSet.getPSDEDataSetGroupParams() as groupParam><#if groupParam_index gt 0>,</#if><#if groupParam.isEnableGroup()><#if groupParam.getGroupCode()??>${groupParam.getGroupCode()}<#else>${groupParam.getName()}</#if><#else>${groupParam.getGroupCode()}</#if> as "${groupParam.getName()?lower_case}"</#list>
</#macro>
